----------------------------------------
-- TFS 143640 - Modello IVA 2020 SaaS --
----------------------------------------

IF EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[CGI5_MODIVA]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
	BEGIN
		IF NOT EXISTS (select * from dbo.syscolumns where id = object_id(N'[dbo].[CGI5_MODIVA]') AND name = 'CGI5_WEBURL' AND length = 8000)
			BEGIN
				DROP TABLE CGI5_MODIVA
			END
	END
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[CGI5_MODIVA]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
	BEGIN

		CREATE TABLE CGI5_MODIVA (
			   CGI5_ID					BIGINT IDENTITY		NOT NULL,
			   CGI5_DITTA_CG18			DECIMAL(5,0)		NOT NULL,
			   CGI5_ANNO				SMALLINT			NOT NULL,
			   CGI5_CODATTIVITA			DECIMAL(5) 			NULL,
			   CGI5_ANNOCOLLQUADRI		SMALLINT			NULL,
			   CGI5_FLGRIEP				TINYINT NOT NULL	DEFAULT ((0)),
			   CGI5_OPESOCC				TINYINT NOT NULL	DEFAULT ((0)),
			   CGI5_IDDICH				UNIQUEIDENTIFIER 	NULL,
			   CGI5_STATO				NCHAR(1)			NULL,
			   CGI5_DICHINFO			NVARCHAR(MAX)		NULL,
			   CGI5_TRACK				NVARCHAR(MAX)		NULL,
			   CGI5_TOKEN				NVARCHAR(4000)		NULL,
			   CGI5_SHA					NVARCHAR(MAX)		NULL,
			   CGI5_BLOB				NVARCHAR(MAX)		NULL,
			   CGI5_WEBURL				NVARCHAR(4000) 		NULL,
			   CGI5_URL					NVARCHAR(4000) 		NULL,
			   CGI5_EMAIL				NVARCHAR(128) 		NULL,
			   CGI5_ROWVERSION			TIMESTAMP			NOT NULL
		)

		CREATE INDEX FK_CGI5_CG18 ON CGI5_MODIVA
		(
			CGI5_DITTA_CG18             ASC
		)

		CREATE INDEX FK_CGI5_CG96 ON CGI5_MODIVA
		(
		   CGI5_DITTA_CG18          	ASC,
		   CGI5_CODATTIVITA             ASC
		)

		ALTER TABLE CGI5_MODIVA
			  ADD CONSTRAINT PK_CGI5
				  PRIMARY KEY (CGI5_ID ASC)

		ALTER TABLE CGI5_MODIVA
			  ADD CONSTRAINT FK_CGI5_CG18
				  FOREIGN KEY (CGI5_DITTA_CG18)
						  REFERENCES CG18_ANADITTABASE (CG18_DITTA)
				  
		ALTER TABLE CGI5_MODIVA
			   ADD CONSTRAINT FK_CGI5_CG96
					  FOREIGN KEY (CGI5_DITTA_CG18, CGI5_CODATTIVITA)
									 REFERENCES CG96_ANAGATTIVITA

		PRINT 'Tabella CGI5_MODIVA: creazione effettuata con successo.'
	END
ELSE
	PRINT 'Tabella CGI5_MODIVA esistente: creazione non effettuata.'
GO